//========================= V1.3 =============================//
//    ___ _            _             _      _    _            //
//   / __| |_  __ _ __| |___ _ _    /_\  __| |__| |___ _ _    //
//   \__ \ ' \/ _` / _` / -_) '_|  / _ \/ _` / _` / _ \ ' \   //
//   |___/_||_\__,_\__,_\___|_|   /_/ \_\__,_\__,_\___/_||_|  //
//                                                            //
//============================================================//
// Shader Addon by Adyss                                      //
// Id like to say thanks to some helping hands. Without some  //
// of them this wouln't exist.                                //
// TreyM: Helping me with general code understanding          //
// The Sandvich Maker: For his super neat tools and advice    //
// LonelyKitsune: Help me with to get the sunposition         //
// Also this uses code bits from: Kingeric1992 and Luluco250  //
//============================================================//

// Toggles an experimental feature. Will draw a gloss effet around brighter areas. Kinda like a reflection. Set it to 1
#define Use_Gloss 0

//==========//
// Textures //
//==========//
Texture2D			TextureOriginal;     // color R16B16G16A16 64 bit hdr format
Texture2D			TextureColor;        // color which is output of previous technique (except when drawed to temporary render target), R16B16G16A16 64 bit hdr format
Texture2D			TextureDepth;        // scene depth R32F 32 bit hdr format
Texture2D			TextureJitter;       // blue noise
Texture2D			TextureMask;         // alpha channel is mask for skinned objects (less than 1) and amount of sss
Texture2D           TextureNormal;       // Normal maps i guess. Also alpha seems to only effect a few selected objects

Texture2D			RenderTargetRGBA32;  // R8G8B8A8 32 bit ldr format
Texture2D			RenderTargetRGBA64;  // R16B16G16A16 64 bit ldr format
Texture2D			RenderTargetRGBA64F; // R16B16G16A16F 64 bit hdr format
Texture2D			RenderTargetR16F;    // R16F 16 bit hdr format with red channel only
Texture2D			RenderTargetR32F;    // R32F 32 bit hdr format with red channel only
Texture2D			RenderTargetRGB32F;  // 32 bit hdr format without alpha

// Include Needes Values
#include "Include/Helper.fxh"
#include "Include/ReforgedUI.fxh"
#include "Include/Conversions.fxh"

//=====//
// GUI //
//=====//
UI_MESSAGE(w1,                  "Shader Addon V1.3")
UI_MESSAGE(w2,                  "by Adyss")
UI_WHITESPACE(1)
#define UI_CATEGORY Godrays
#define UI_PREFIX_MODE PREFIX
UI_SEPARATOR
UI_BOOL(ToggleRays,             "Toggle",                         false)
UI_INT(Samples,                 "Samples",                        2.0, 10.0, 2.0)
UI_FLOAT3(SunColor,             "Color",                          0.85, 0.73, 0.62)
UI_FLOAT(RayPower,              "Power",                          0.0, 7.0, 3.0)
UI_FLOAT(RayTight,              "Tightness",                      0.5, 3.0, 1.0)
UI_FLOAT(RayLength,             "Length",                         0.2, 5.0, 1.0)
UI_BOOL(Use_BoxBlur,            "Enable Box Blur",                false)
UI_FLOAT(BBRadius,              "Box Blur Radius",                0.5, 10.0, 1.0)
UI_WHITESPACE(2)
#define UI_CATEGORY Skin
UI_SEPARATOR
UI_FLOAT(SkinGamma,             "Gamma",                          0.5, 3.0, 1.0)
UI_FLOAT(SkinExposure,          "Exposure",                      -2.0, 2.0, 0.0)
UI_FLOAT3(SkinTint,             "Tint",                           0.55, 0.43, 0.42)
UI_FLOAT(SkinTintStrength,      "Tint Power",                     0.0, 1.0, 0.0)
UI_FLOAT(SkinHue,               "Hue",                            0.0, 6.0, 0.0)
UI_FLOAT(HueOpacity,            "Hue opacity",                    0.0, 1.0, 0.0)
UI_WHITESPACE(3)
#define UI_CATEGORY Sky
UI_SEPARATOR
UI_FLOAT(SkyGamma,              "Gamma",                          0.5, 3.0, 1.0)
UI_FLOAT(SkySaturation,         "Saturation",                     0.0, 2.0, 1.0)
UI_FLOAT3(SkyTint,              "Tint",                           0.55, 0.43, 0.42)
UI_FLOAT(SkyTintStrength,       "Tint Power",                     0.0, 1.0, 0.0)
UI_BOOL(SkyDither,              "Dither",                         false)
#if Use_Gloss == 1
UI_WHITESPACE(4)
#define UI_CATEGORY Gloss
UI_SEPARATOR
UI_INT(rSamples,                 "Samples",                       2.0, 100.0, 2.0)
UI_FLOAT(rBlurSize,              "Blur Size",                     0.0, 30.0, 1.0)
#endif
//===========//
// Functions //
//===========//
float2 getSun()
{
    float3 Sundir       = SunDirection.xyz / SunDirection.w;
    float2 Suncoord     = Sundir.xy / Sundir.z;
           Suncoord     = Suncoord * float2(0.48, ScreenSize.z * 0.48) + 0.5;
           Suncoord.y   = 1.0 - Suncoord.y;
    return Suncoord;
}

/* This code was automatically generated by gaussianGenerator.py
   Number of filter taps per pass: 20
   Number of texture samples per pass: 11 */

static const float gaussianWeights[6] = { 0.161180738153, 0.265682535417, 0.121771162066, 0.0286520381333, 0.00316680421473, 0.000137091091547 };
static const float gaussianOffsets[6] = { 0.0, 1.44, 3.36, 5.28, 7.2, 9.12 };
static const int gaussianLoopLength   = 6;

float4 ApplyToSkin(float4 SkinColor, float2 coord)
{
    return lerp(SkinColor, TextureColor.Sample(LinearSampler, coord), TextureMask.Sample(LinearSampler, coord).w);
}

float4 SkinColorEdit(float4 Color)
{
    Color      = pow(Color, SkinGamma);
    Color      = ldexp(Color, SkinExposure);
    Color.rgb  = lerp(Color, Color * SkinTint * 2.55, SkinTintStrength);
    float3 hsv = RGBtoHSV(Color.rgb);
    hsv.x     += SkinHue;
    Color.rgb  = lerp(Color, HSVtoRGB(hsv), HueOpacity);
    return       Color;
}

// ALU noise in Next-gen post processing in COD:AW
float InterleavedGradientNoise( float2 uv )
{
    float3 magic = { 0.06711056, 0.00583715, 52.9829189 };
    return frac( magic.z * frac( dot( uv, magic.xy ) ) );
}

// from "The Unreasonable Effectiveness of Quasirandom Sequences"
// http://extremelearning.com.au/unreasonable-effectiveness-of-quasirandom-sequences/
float r_dither(float2 co)
{
	const float2 magic = (0.75487766624669276, 0.569840290998);
    return frac(dot(co, magic));
}

float remapTri(float n)
{
    float orig = n * 2.0 - 1.0;
    n = orig * rsqrt(abs(orig));
    return max(-1.0, n) - sign(orig);
}

float3 BoxBlur(Texture2D inputTex, float2 coord, float2 ps)
{
	return (inputTex.Sample(LinearSampler, coord - ps * 0.5).rgb +
			inputTex.Sample(LinearSampler, coord + ps * 0.5).rgb +
			inputTex.Sample(LinearSampler, coord + float2(-ps.x, ps.y) * 0.5).rgb +
			inputTex.Sample(LinearSampler, coord + float2( ps.x,-ps.y) * 0.5).rgb) * 0.25;
}

// Golden Ratio
static const float gr = (1.0 + sqrt(5.0)) * 0.5;

//===============//
// Pixel Shaders //
//===============//
float3	PS_SkyMask(VS_OUTPUT IN) : SV_Target
{
    float  Mask    = TextureNormal.Sample(PointSampler, IN.txcoord.xy).w * GetLinearizedDepth(IN.txcoord.xy);
           Mask    = floor(Mask);
    float3 Color   = TextureColor.Sample(PointSampler, IN.txcoord.xy) * Mask;
    return Color;
}

float3	PS_DrawRays(VS_OUTPUT IN, float4 v0 : SV_Position0) : SV_Target
{
    if (!ToggleRays) return 0;
    float2 coord        = IN.txcoord.xy;
    float  Rays         = 0;
    float2 Sunpos       = (coord - getSun()) * ((1.0 / Samples) * RayLength);
    float  Jitter       = TextureJitter.Load(int3(v0.xy % 16, 0)); // Thanks Sandvich

    for(int i = 1; i < Samples; i++)
    {
               Jitter         = frac(Jitter + gr * i);
        float2 Offset         = lerp(coord, coord - Sunpos, Jitter);
               Rays          += TextureColor.Sample(LinearSampler, Offset);
    }

    Rays /= Samples;  // Normalize

    return Rays;
}

float3	PS_RayBlurH(VS_OUTPUT IN) : SV_Target
{
    if (!ToggleRays) return 0;
    float2 coord   = IN.txcoord.xy;
    float3 Blur    = TextureColor.Sample(LinearSampler, coord) * gaussianWeights[0];

    for (int i = 1; i < gaussianLoopLength; i++)
    {
        Blur += TextureColor.Sample(LinearSampler, coord + float2(gaussianOffsets[i], 0.0) * PixelSize) * gaussianWeights[i];
        Blur += TextureColor.Sample(LinearSampler, coord - float2(gaussianOffsets[i], 0.0) * PixelSize) * gaussianWeights[i];
    }

    return Blur;
}

float3	PS_RayBlurV(VS_OUTPUT IN) : SV_Target
{
    if (!ToggleRays) return 0;

    float2 coord   = IN.txcoord.xy;
    float3 Blur    = TextureColor.Sample(LinearSampler, coord) * gaussianWeights[0];

    for (int i = 1; i < gaussianLoopLength; i++)
    {
        Blur += TextureColor.Sample(LinearSampler, coord + float2(0.0, gaussianOffsets[i]) * PixelSize) * gaussianWeights[i];
        Blur += TextureColor.Sample(LinearSampler, coord - float2(0.0, gaussianOffsets[i]) * PixelSize) * gaussianWeights[i];
    }

    return Blur;
}

float3	PS_RaysCombine(VS_OUTPUT IN) : SV_Target
{
    float3 Rays;

           if (!Use_BoxBlur)
           Rays         = TextureColor.Sample(LinearSampler, IN.txcoord.xy);

           if (Use_BoxBlur)
           Rays         = BoxBlur(TextureColor, IN.txcoord.xy, PixelSize * BBRadius);

           Rays        *= SunColor;
           Rays        *= RayPower;
           Rays         = pow(Rays, RayTight); // Makes them look a bit better but not on higher values
    float3 Color        = TextureOriginal.Sample(PointSampler, IN.txcoord.xy);
    float2 Sun          = getSun();

           if (SunDirection.z > 0.2 && EInteriorFactor < 1.0 && ToggleRays > 0.99)
           Color        = lerp(Color, lerp(Color, Color + Rays, SunDirection.z * 0.3), ENightDayFactor); // lerp cuz its smooth (dont even question it... please)
    return Color;
}

float4	PS_Skin(VS_OUTPUT IN) : SV_Target
{
    return ApplyToSkin(SkinColorEdit(TextureColor.Sample(LinearSampler, IN.txcoord.xy)), IN.txcoord.xy);
}

#define BIT_DEPTH 8

float3	PS_Sky(VS_OUTPUT IN, float4 v0 : SV_Position0) : SV_Target
{
    float3 Color        = TextureColor.Sample(PointSampler, IN.txcoord.xy);
    float  Mask         = TextureNormal.Sample(PointSampler, IN.txcoord.xy).w * GetLinearizedDepth(IN.txcoord.xy); // Just dont even ask
           Mask         = floor(Mask);
    float3 Sky          = pow(Color, SkyGamma);
           Sky          = lerp(GetLuma(Sky, Rec709), Sky , SkySaturation);
           Sky          = lerp(Sky, Sky * SkyTint * 2.55, SkyTintStrength);

    if (SkyDither)
    {
        float Dither = r_dither(v0);
              Dither = remapTri(Dither);
        float lsb    = exp2(float(BIT_DEPTH)) - 1.0;
              Sky    += Dither / lsb;
              Sky    = round(Sky * lsb) / lsb;
    }

    return lerp(Color, Sky, Mask);
}

#if Use_Gloss == 1
float3	PS_Gloss(VS_OUTPUT IN, float4 v0 : SV_Position0) : SV_Target
{
    float2 coord     = IN.txcoord.xy;
    float4 Normals   = TextureNormal.Sample(PointSampler, coord);
           Normals.w = lerp(Normals.w, 0.0, GetLinearizedDepth(coord)); // Screwed idea
    float3 Gloss     = 0;

    for(int i = 1; i < rSamples; i++)
    {
        float2 Offset = coord + Normals.xy * PixelSize.xy * (i / Samples) * rBlurSize;
               Gloss += TextureOriginal.Sample(LinearSampler, Offset);
    }

           Gloss    /= rSamples;

    float3 Color     = TextureColor.Sample(PointSampler, coord);

    return Color + Gloss / 2;
}
#endif

// TECHNIQUES
technique11 pre <string UIName="Shader Addon";>
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_SkyMask()));
    }
}

technique11 pre1
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_DrawRays()));
    }
}

technique11 pre2
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_DrawRays()));
    }
}

technique11 pre3
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_DrawRays()));
    }
}

technique11 pre4
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_RayBlurH()));
    }
}

technique11 pre5
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_RayBlurV()));
    }
}

technique11 pre6
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_RaysCombine()));
    }
}

technique11 pre7
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_Skin()));
    }
}

technique11 pre8
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_Sky()));
    }
}

#if Use_Gloss == 1
technique11 pre9
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_5_0, VS_Draw()));
        SetPixelShader (CompileShader(ps_5_0, PS_Gloss()));
    }
}
#endif
